﻿var svgNS = "http://www.w3.org/2000/svg";
var xlinkNS = "http://www.w3.org/1999/xlink";
var tabs = new Array();
currentTab = null;
currentRoom = null;
currentText = 0;
maxMapWidth=0;
maxMapHeight=0;
absolutewidth=1280;
absoluteheight=1024;

function wordWrap(text, textObject, length)
{
   // Build up the string
   var i=0;
   var words=text.split(" ");
   var lines=new Array();
   var line=new Array();
   textPtr=textObject.firstChild;
   while (words.length)
   {
      var word=words[0];
      textPtr.nodeValue = line.join(' ') + ' ' + word;
      outline = textObject.getComputedTextLength();
         
      if (outline > length)
      {
         if (!words.length)
         {
            line.push(words[0]);
         }
         lines.push(line);
         line = new Array();
      }
      else
      {
         line.push(words.shift());
      }
      if (words.length == 0)
      {
         lines.push( line );
      }
   }
   return lines;
}

function displayWordWrap(lines, align, textObject, length)
{
   var i;
   line=new Array();
   while (textObject.hasChildNodes())
   {
      textObject.removeChild(textObject.firstChild);
   }
   textObject.appendChild(document.createTextNode(''));
   anchor='start';
   for (var i=0; i<lines.length; i++)
   {
      var x = 4;      
      line = lines[i]; 
      textObject.appendChild( document.createTextNode(' ') );
      var tspan = document.createElementNS(svgNS, 'tspan');
      tspan.appendChild( document.createTextNode(line.join(' ')) ); 
      if (align == 'centre')
      {
       anchor = 'middle';
       x = length / 2;
      }  
      tspan.setAttribute('x', x);
      tspan.setAttribute('dy', i?'1.6em':'0.1em');
      textObject.appendChild(tspan);
   }
   textObject.setAttributeNS(null,"text-anchor",anchor);
}

function displayToolTip(evt)
{
   var x;
   var y;
   var Target = evt.target;

   x = evt.clientX + 20;   // the tooltip will be located at the event x,y coordinates
   y = evt.clientY + 20;
   
   if ((x + roomWidth*2) > (maxMapWidth+1)*(roomWidth+roomXGap) + roomXStart + roomXStart)
   {
      x=((maxMapWidth+1)*(roomWidth+roomXGap) + roomXStart + roomXStart)-(roomWidth*2)-20;
   }

   ToolTip = document.getElementById('ToolTip');            
   ToolTip.setAttributeNS(null,"transform","translate(" + x + "," + y + ")");

   ToolTipText = document.getElementById("ToolTipText");
   ToolTipBox = document.getElementById("ToolTipBox");
   
   TitleObject = Target.getElementsByTagName('desc').item(0);
   var lines=wordWrap(TitleObject.firstChild.nodeValue, ToolTipText, roomWidth*2);
   displayWordWrap(lines, "left", ToolTipText, roomWidth*2);      

   var outline = ToolTipText.getBBox();
   ToolTipBox.setAttributeNS(null, 'width', Number(outline.width) + 10);
   ToolTipBox.setAttributeNS(null, 'height', Number(outline.height) + 10);
   
   ToolTip.setAttributeNS(null, "visibility", "visible");
}

function hideToolTip(evt)
{
   ToolTip=document.getElementById('ToolTip');
   ToolTip.setAttributeNS(null, 'visibility', 'hidden');
   ToolTipText=document.getElementById("ToolTipText");
   while (ToolTipText.hasChildNodes())
   {
      ToolTipText.removeChild(ToolTipText.firstChild);
   }
   ToolTipText.appendChild(document.createTextNode(''));
};

function setTab(tab)
{
   currentTab=tab;
}

function setRoom(room)
{
   currentRoom=room;
}

function addTab(tab, name, number)
{
   var newTab = document.createElementNS(svgNS, "g");
   newTab.setAttributeNS(null,"id",tab);
   newTab.setAttributeNS(null,"visibility","hidden");
   document.getElementById("map").appendChild(newTab);
   tabs.push(newTab);
   
   var newRect = document.createElementNS(svgNS, "rect");
   newRect.setAttributeNS(null,"x",2);
   newRect.setAttributeNS(null,"width",1278);
   newRect.setAttributeNS(null,"y",30);
   newRect.setAttributeNS(null,"height",1022);
   newRect.setAttributeNS(null,"rx",2);
   newRect.setAttributeNS(null,"ry",2);
   newRect.setAttributeNS(null,"stroke","black");
   newRect.setAttributeNS(null,"fill","white");
   newTab.appendChild(newRect);
      
   newRect=document.createElementNS(svgNS, "rect");
   newRect.setAttributeNS(null,"id",tab + "rect");
   newRect.setAttributeNS(null,"x",2+(number-1)*(roomWidth*1.25));
   newRect.setAttributeNS(null,"width",roomWidth*1.25);
   newRect.setAttributeNS(null,"y",2);
   newRect.setAttributeNS(null,"height",28);
   newRect.setAttributeNS(null,"rx",2);
   newRect.setAttributeNS(null,"ry",2);
   newRect.setAttributeNS(null,"stroke","black");
   newRect.setAttributeNS(null,"fill","lightgrey");
   newRect.setAttributeNS(null,"onclick","clickActiveTab(evt);"); 
   document.getElementById("map").appendChild(newRect);
   
   newText=document.createElementNS(svgNS, "text");
   newText.setAttributeNS(null,"id",tab + "text");
   newText.setAttributeNS(null,"x",4+(number-1)*(roomWidth*1.25));
   newText.setAttributeNS(null,"y","20");
   newText.setAttributeNS(null,"style","fill:black;font-family:Verdana,sans serif;font-size:10pt");
   newText.appendChild(document.createTextNode(name));
   newText.setAttributeNS(null,"onclick","clickActiveTab(evt);"); 
   document.getElementById("map").appendChild(newText);
   
   setTab(tab);
}

function addText(text, x, y)
{
   // First work out x and y.
   var xpixels=x*(roomWidth+roomXGap) + roomXStart;
   var ypixels=y*(roomHeight+roomYGap) + roomYStart;
   
   currentText++;
   id="freetext-" + currentText
   
   if (x>maxMapWidth) maxMapWidth=x;
   if (y>maxMapHeight) maxMapHeight=y;
   
   // Now write the data straight into the document
   var newRoom = document.createElementNS(svgNS,"g");
   newRoom.setAttributeNS(null,"id",id);   
   newRoom.setAttributeNS(null,"transform","translate(" + xpixels + "," + ypixels+ ")");   
   document.getElementById(currentTab).appendChild(newRoom);
   setRoom(id);

   var newBorder=document.createElementNS(svgNS,"rect");
   with (newBorder)
   {
      setAttributeNS(null,"id","border-" + id);
      setAttributeNS(null,"width",roomWidth);
      setAttributeNS(null,"height",roomHeight);
      setAttributeNS(null,"stroke","white");
      setAttributeNS(null,"fill","white");
   } 
   document.getElementById(id).appendChild(newBorder);

   var newDesc = document.createElementNS(svgNS,"text");
   newDesc.setAttributeNS(null,"style","fill:black;font-family:Verdana,sans serif;font-size:5pt");
   newDesc.setAttributeNS(null,"text-anchor","middle");
   newDesc.setAttributeNS(null,"x",roomWidth/2);
   newDesc.setAttributeNS(null,"y","10");
   newDesc.appendChild(document.createTextNode(" "));
   newDesc.setAttributeNS(null,"style","fill:black;font-family:Verdana,sans serif;font-size:6pt");
   document.getElementById(id).appendChild(newDesc);
   Lines=wordWrap(text, newDesc, roomWidth-2);
   var y=roomHeight/4-5;
   if (Lines.length==1) y=roomHeight/2+5;
   if (Lines.length==2) y=roomHeight/3+5;
   if (Lines.length==3) y=roomHeight/6+5;
   newDesc.setAttributeNS(null,"y",y);
   displayWordWrap(Lines, "centre", newDesc, roomWidth);
   document.getElementById(id).appendChild(newDesc);

}

function addRoom(id, name, x, y, image, objects, comments, death)
{
   // Namespace variables

   // First work out x and y.
   var xpixels=x*(roomWidth+roomXGap) + roomXStart;
   var ypixels=y*(roomHeight+roomYGap) + roomYStart;
   
   if (x>maxMapWidth) maxMapWidth=x;
   if (y>maxMapHeight) maxMapHeight=y;
   
   // Now write the data straight into the document
   var newRoom = document.createElementNS(svgNS,"g");
   newRoom.setAttributeNS(null,"id",id);   
   newRoom.setAttributeNS(null,"transform","translate(" + xpixels + "," + ypixels+ ")");   
   document.getElementById(currentTab).appendChild(newRoom);
   setRoom(id);

   var newBorder=document.createElementNS(svgNS,"rect");
   with (newBorder)
   {
      setAttributeNS(null,"id","border-" + id);
      setAttributeNS(null,"rx","2");
      setAttributeNS(null,"ry","2");
      setAttributeNS(null,"width",roomWidth);
      setAttributeNS(null,"height",roomHeight);
      setAttributeNS(null,"stroke","black");
      setAttributeNS(null,"fill","white");
   } 
   document.getElementById(id).appendChild(newBorder);
   
   var newDesc = document.createElementNS(svgNS,"text");
   newDesc.setAttributeNS(null,"style","fill:black;font-family:Verdana,sans serif;font-size:5pt");
   newDesc.setAttributeNS(null,"text-anchor","middle");
   newDesc.setAttributeNS(null,"x",roomWidth/2);
   newDesc.setAttributeNS(null,"y","10");
   
   if (image)
   {
      var newImage = document.createElementNS(svgNS,"image");
      newImage.setAttributeNS(null,"x","10");
      newImage.setAttributeNS(null,"y","15");
      newImage.setAttributeNS(null,"width","100");
      newImage.setAttributeNS(null,"height","57");
      newImage.setAttributeNS(xlinkNS,"href",image);
      newDesc.appendChild(document.createTextNode(name));
      document.getElementById(id).appendChild(newImage);
   }
   else
   {  // No image we need to format the text to use image space
      // First off split the image for number of lines
      newDesc.appendChild(document.createTextNode(" "));
      newDesc.setAttributeNS(null,"style","fill:black;font-family:Verdana,sans serif;font-size:6pt");
      document.getElementById(id).appendChild(newDesc);
      Lines=wordWrap(name, newDesc, roomWidth-2);
      var y=roomHeight/4-5;
      if (Lines.length==1) y=roomHeight/2+5;
      if (Lines.length==2) y=roomHeight/3+5;
      if (Lines.length==3) y=roomHeight/6+5;
      newDesc.setAttributeNS(null,"y",y);
      displayWordWrap(Lines, "centre", newDesc, roomWidth);
   }
   document.getElementById(id).appendChild(newDesc);
   
   if (objects)
   {
      var newObjects = document.createElementNS(svgNS, "polygon");
      newObjects.setAttributeNS(null,"id","objects" + id);
      newObjects.setAttributeNS(null,"style","fill:blue;stroke:blue");
      newObjects.setAttributeNS(null,"onmouseover","displayToolTip(evt);");
      newObjects.setAttributeNS(null,"onmouseout","hideToolTip(evt);"); 
      newObjects.setAttributeNS(null,"points",roomWidth-8 + ",0," + roomWidth +",0," + roomWidth + ",8");
      document.getElementById(id).appendChild(newObjects);
      var newRollover = document.createElementNS(svgNS, "desc");
      newRollover.appendChild(document.createTextNode(objects));
      document.getElementById("objects" + id).appendChild(newRollover);
   }

   if (comments)
   {
      var newComments = document.createElementNS(svgNS, "polygon");
      newComments.setAttributeNS(null,"id","comments" + id);
      newComments.setAttributeNS(null,"style","fill:green;stroke:green");
      newComments.setAttributeNS(null,"onmouseover","displayToolTip(evt);");
      newComments.setAttributeNS(null,"onmouseout","hideToolTip(evt);"); 
      newComments.setAttributeNS(null,"points",roomWidth-8 + "," + roomHeight + "," + roomWidth + "," + roomHeight + "," + roomWidth + "," + (roomHeight-8));
      document.getElementById(id).appendChild(newComments);
      var newRollover = document.createElementNS(svgNS, "desc");
      newRollover.appendChild(document.createTextNode(comments));
      document.getElementById("comments" + id).appendChild(newRollover);
   }
   
   if (death)
   {
      var newDeath = document.createElementNS(svgNS,"text");
      newDeath.setAttributeNS(null,"id","death" + id);
      newDeath.setAttributeNS(null,"style","fill:red;font-family:Verdana,sans serif;font-size:8pt");
      newDeath.setAttributeNS(null,"text-anchor","middle");
      newDeath.setAttributeNS(null,"x","7");
      newDeath.setAttributeNS(null,"y","12");
      newDeath.setAttributeNS(null,"onmouseover","displayToolTip(evt);");
      newDeath.setAttributeNS(null,"onmouseout","hideToolTip(evt);"); 
      newDeath.appendChild(document.createTextNode("X"));
      var newRollover = document.createElementNS(svgNS, "desc");
      newRollover.appendChild(document.createTextNode(death));
      document.getElementById(id).appendChild(newDeath);
      document.getElementById("death" + id).appendChild(newRollover);
   }
}

function addJump(toTab, description, x, y, orientation)
{
   var xpixels=x*(roomWidth+roomXGap) + roomXStart;
   var ypixels=y*(roomHeight+roomYGap) + roomYStart;
   var id="Jump-" + currentTab + "-" + toTab;
   var points;
   var xtext,ytext;
   
   if (x>maxMapWidth) maxMapWidth=x;
   if (y>maxMapHeight) maxMapHeight=y;
   
   points="0," + roomHeight + "," + roomWidth + "," + roomHeight + "," + roomWidth/2 + ",0"
   xtext=roomWidth/2;
   ytext=(roomHeight*7)/8;
   if (orientation)
   {
      switch (orientation)
      {
         case "North":
            // default - no action
            break;
         case "South":
            points="0,0," + roomWidth + ",0," + roomWidth/2 + "," + roomHeight;
            ytext=((roomHeight*2)/8)-4;
            break;
         case "East":
            points="0,0,0," + roomHeight + "," + roomWidth + "," + roomHeight/2;
            ytext=(roomHeight/2)+4;           
            xtext-=4;
            break;
         case "West":
            points="0," + roomHeight/2 + "," + roomWidth + ",0," + roomWidth + "," + roomHeight;
            ytext=(roomHeight/2)+4;
            xtext+=8;
            break;
      }
   }
   
   // Now write the data straight into the document
   var newRoom = document.createElementNS(svgNS,"g");
   newRoom.setAttributeNS(null,"id","group-" + id);   
   newRoom.setAttributeNS(null,"transform","translate(" + xpixels + "," + ypixels+ ")");   
   document.getElementById(currentTab).appendChild(newRoom);

   var newJump = document.createElementNS(svgNS, "polygon");
   newJump.setAttributeNS(null,"id","shape-" + id);   
   newJump.setAttributeNS(null,"style","stroke:black;fill:white");
   newJump.setAttributeNS(null,"points",points);
   newJump.setAttributeNS(null,"onclick","clickJump(evt);"); 
   document.getElementById("group-" + id).appendChild(newJump);
   
   var newDesc = document.createElementNS(svgNS,"text");
   newDesc.setAttributeNS(null,"id","text-" + id);   
   newDesc.setAttributeNS(null,"style","fill:black;font-family:Verdana,sans serif;font-size:6pt");
   newDesc.setAttributeNS(null,"text-anchor","middle");
   newDesc.setAttributeNS(null,"x",xtext);
   newDesc.setAttributeNS(null,"y",ytext);
   newDesc.setAttributeNS(null,"onclick","clickJump(evt);"); 
   newDesc.appendChild(document.createTextNode(description));
   document.getElementById("group-" + id).appendChild(newDesc);
}

function addExit(direction, mod, oneway, updown, inout)
{
   // Direction is the direction
   // mod is if you have to use a strange command or solve a puzzle to go there
   // oneway is if you can't go back
   var svgNS = "http://www.w3.org/2000/svg";
   var xlinkNS = "http://www.w3.org/1999/xlink";
   
   startRoom=document.getElementById(currentRoom);
   var transform=startRoom.getAttributeNS(null,"transform");
   var x=parseInt(transform.substr(transform.indexOf("(")+1,transform.indexOf(",")-transform.indexOf("(")-1));
   var y=parseInt(transform.substr(transform.indexOf(",")+1,transform.indexOf(")")-transform.indexOf(",")-1));

   exitStyle="stroke:black;stroke-width:2";
   if (mod)
   {
      exitStyle+=";stroke-dasharray: 5,5";
   }
   
   switch(direction)
   {
      case "East":
         x1=x + roomWidth; x2=x + roomWidth+roomXGap;
         y1=y + roomHeight/2;  y2=y + roomHeight/2;
         ArrowCoords=(x2-5) +"," + (y2-3) + "," + (x2) + "," + (y2) + "," + (x2-5) + "," + (y2+3);
         ux=x2-5; uy=y2+12;
         dx=x1+6; dy=y1-5;
         break;
      case "West":
         x1=x; x2=x - roomXGap;
         y1=y+roomHeight/2;  y2=y + roomHeight/2;
         ArrowCoords=(x2+5) +"," + (y2-3) + "," + (x2) + "," + (y2) + "," + (x2+5) + "," + (y2+3);
         ux=x2+5; uy=y2+12;
         dx=x1-5; dy=y1-5;
         break;
      case "South":
         x1=x + roomWidth/2; x2=x + roomWidth/2;
         y1=y + roomHeight; y2=y + roomHeight + roomYGap;
         ArrowCoords=(x1-3) +"," + (y2-6) + "," + (x1+3) + "," + (y2-6) + "," + (x1) + "," + (y2);
         dx=x1-8; dy=y1+12;
         ux=x2+7; uy=y2-3;
         break;
      case "North":
         x1=x + roomWidth/2; x2=x + roomWidth/2;
         y1=y; y2=y - roomYGap;
         ArrowCoords=(x1-3) +"," + (y2+6) + "," + (x1+3) + "," + (y2+6) + "," + (x1) + "," + (y2);
         ux=x1+8; uy=y1-9;
         dx=x2-7; dy=y2+14;
         break;
      case "SouthEast":
         x1=x + roomWidth; x2=x + roomWidth+roomXGap;
         y1=y + roomHeight; y2=y+ roomHeight + roomYGap;
         ArrowCoords=(x+138) +"," + (y+104) + "," + (x+145) + "," + (y+105) + "," + (x+144) + "," + (y+98);
         ux=x1+10; uy=y1+2;
         dx=x2-9; dy=y2+4;
         break;         
      case "SouthWest":
         x1=x; x2=x - roomXGap;
         y1=y + roomHeight; y2=y+ roomHeight + roomYGap;
         ArrowCoords=(x+138) +"," + (y+104) + "," + (x+145) + "," + (y+105) + "," + (x+144) + "," + (y+98);
         ux=x+118; uy=y+92;
         dx=x+150; dy=y+102;
         break;         
      case "NorthEast":
         x1=x + roomWidth; x2=x + roomWidth+roomXGap;
         y1=y; y2=y - roomYGap;
         ArrowCoords=(x2-2) +"," + (y2+6) + "," + (x2-6) + "," + (y2+2) + "," + (x2) + "," + (y2);
         ux=x1+10; uy=y1-15;
         dx=x2-9; dy=y2+20;
         break;         
      case "NorthWest":
         x1=x; x2=x - roomXGap;
         y1=y; y2=y - roomYGap;
         ArrowCoords=(x2+2) +"," + (y2+6) + "," + (x2+6) + "," + (y2+2) + "," + (x2) + "," + (y2);
         ux=x2+5; uy=y1-2;
         dx=x1-4; dy=y2+8;
         break;         
   }
   var newExit = document.createElementNS(svgNS, "line");
   newExit.setAttributeNS(null,"id",currentRoom + direction);
   newExit.setAttributeNS(null,"style",exitStyle);
   newExit.setAttributeNS(null,"x1",x1);
   newExit.setAttributeNS(null,"x2",x2);
   newExit.setAttributeNS(null,"y1",y1);
   newExit.setAttributeNS(null,"y2",y2);
   document.getElementById(currentTab).appendChild(newExit);
   if (oneway) 
   {
      var newArrow = document.createElementNS(svgNS,"polygon");
      newArrow.setAttributeNS(null,"style","stroke:black;fill:black");
      newArrow.setAttributeNS(null,"points",ArrowCoords);

      document.getElementById(currentTab).appendChild(newArrow);
   }
   if (updown || inout)
   {
      if (updown) { downchar="d"; upchar="u"; }
      if (inout) { downchar="i"; upchar="o"; }
      var dText = document.createElementNS(svgNS,"text");
      dText.setAttributeNS(null,"style","fill:black;font-family:Verdana,sans serif;font-size:6pt");
      dText.setAttributeNS(null,"text-anchor","middle");
      dText.setAttributeNS(null,"x",dx);
      dText.setAttributeNS(null,"y",dy);
      dText.appendChild(document.createTextNode(downchar));
      var uText = document.createElementNS(svgNS,"text");
      uText.setAttributeNS(null,"style","fill:black;font-family:Verdana,sans serif;font-size:6pt");
      uText.setAttributeNS(null,"text-anchor","middle");
      uText.setAttributeNS(null,"x",ux);
      uText.setAttributeNS(null,"y",uy);
      uText.appendChild(document.createTextNode(upchar));
      document.getElementById(currentTab).appendChild(dText);
      document.getElementById(currentTab).appendChild(uText);
   }
}

function connectRooms(room1, room2, mod, oneway)
{
   // Connect two rooms with a straight line
   
   // first work out the co-ordinates of each room
   startRoom=document.getElementById(room1);
   var startTransform=startRoom.getAttributeNS(null,"transform");
   var startx=parseInt(startTransform.substr(startTransform.indexOf("(")+1,startTransform.indexOf(",")-startTransform.indexOf("(")-1));
   var starty=parseInt(startTransform.substr(startTransform.indexOf(",")+1,startTransform.indexOf(")")-startTransform.indexOf(",")-1));
   var startxmid=startx+roomWidth/2; var startymid=starty+roomHeight/2;
   
   endRoom=document.getElementById(room2);
   var endTransform=endRoom.getAttributeNS(null,"transform");
   var endx=parseInt(endTransform.substr(endTransform.indexOf("(")+1,endTransform.indexOf(",")-endTransform.indexOf("(")-1));
   var endy=parseInt(endTransform.substr(endTransform.indexOf(",")+1,endTransform.indexOf(")")-endTransform.indexOf(",")-1));
   var endxmid=endx+roomWidth/2; var endymid=endy+roomHeight/2;
   
   exitStyle="stroke:black;stroke-width:2";
   if (mod)
   {
      exitStyle+=";stroke-dasharray: 5,5";
   }
   
   linestartx=startxmid; linestarty=startymid;
   lineendx=endxmid; lineendy=endymid;      
   if (endxmid > startxmid) { lineendx-=roomWidth/2; linestartx+=roomWidth/2; }
   if (endxmid < startxmid) { lineendx+=roomWidth/2; linestartx-=roomWidth/2; }
   if (endymid > startymid) { lineendy-=roomHeight/2; linestarty+=roomHeight/2; }
   if (endymid < startymid) { lineendy+=roomHeight/2; linestarty-=roomHeight/2; }

   var newExit = document.createElementNS(svgNS, "line");
   newExit.setAttributeNS(null,"id",room1 + room2);
   newExit.setAttributeNS(null,"style",exitStyle);
   newExit.setAttributeNS(null,"x1",linestartx);
   newExit.setAttributeNS(null,"x2",lineendx);
   newExit.setAttributeNS(null,"y1",linestarty);
   newExit.setAttributeNS(null,"y2",lineendy);
   document.getElementById(currentTab).appendChild(newExit);
}

function setStartRoom(Room)
{
   // Add a Blue bar at the bottom of the start room
   var svgNS = "http://www.w3.org/2000/svg";
   var xlinkNS = "http://www.w3.org/1999/xlink";
   var startRoom=document.getElementById(Room);
   
   var newRect=document.createElementNS(svgNS,"rect");
   newRect.setAttributeNS(null,"width",roomWidth-2);
   newRect.setAttributeNS(null,"height",2);
   newRect.setAttributeNS(null,"x",1);
   newRect.setAttributeNS(null,"y",roomHeight-3);
   newRect.setAttributeNS(null,"style","fill:blue;stroke:blue");
   startRoom.appendChild(newRect);
}

function clickActiveTab(evt)
{
   tab=evt.target.getAttributeNS(null,"id");
   setActiveTab(tab.substr(0,tab.length-4));
}

function clickJump(evt)
{
   var i;
   var tab=evt.target.getAttributeNS(null,"id");
   var elements=tab.split("-");
   
   setActiveTab(elements[3]);
}

function setActiveTab(tab)
{
   var i;
   // First off make the active tab visible
   activeTab=document.getElementById(tab);
   activeTab.setAttributeNS(null,"visibility","visible");
   tabRectangle=document.getElementById(tab + "rect");
   tabRectangle.setAttributeNS(null, "y", "2");
   tabRectangle.setAttributeNS(null, "height", "28");            
   tabRectangle.setAttributeNS(null, "fill", "white");
   
   // Now look through all the other tabs and set them as hidden
   for (i=0; i<tabs.length; i++)
   {
      if (tabs[i] != activeTab)
      {
         tabs[i].setAttributeNS(null,"visibility","hidden");
         tabName=tabs[i].getAttributeNS(null,"id");
         tabRectangle=document.getElementById(tabName + "rect");
         tabRectangle.setAttributeNS(null, "y", "6");
         tabRectangle.setAttributeNS(null, "height", "24");            
         tabRectangle.setAttributeNS(null, "fill", "lightgrey");
      }
   }
}

function resizeMap()
{
   var tabslength=tabs.length*roomWidth*1.25 + 30;
   var xpixels=(maxMapWidth+1)*(roomWidth+roomXGap) + roomXStart;   
   var ypixels=maxMapHeight*(roomHeight+roomYGap) + (roomYStart*2) + 30;

   if (tabslength > xpixels) xpixels = tabslength;
   
   // Now set all tabs to that side.
   for (i=0; i<tabs.length; i++)
   {
         tabs[i].setAttributeNS(null,"width",xpixels);
         tabs[i].setAttributeNS(null,"height",ypixels);
         tabs[i].firstChild.setAttributeNS(null,"width",xpixels-4);
         tabs[i].firstChild.setAttributeNS(null,"height",ypixels-4);
   }
   
   absolutewidth=xpixels;
   absoluteheight=ypixels;
}

function addKey(title,subtitle)
{
   var keyGroup=document.createElementNS(svgNS,"g");
   keyGroup.setAttributeNS(null,"id","group-key");
   keyGroup.setAttributeNS(null,"style","fill:black;font-family:Verdana,sans serif; font-size: 10pt;");
   
   var keyRect=document.createElementNS(svgNS,"rect");
   with (keyRect) {
      setAttributeNS(null,"width","260");
      setAttributeNS(null,"height","247");
      setAttributeNS(null,"rx","2");
      setAttributeNS(null,"ry","2");
      setAttributeNS(null,"stroke","black");
      setAttributeNS(null,"fill","white");
   }
   keyGroup.appendChild(keyRect);
   
   var titleText=document.createElementNS(svgNS,"text");
   with (titleText) {
      setAttributeNS(null,"style","font-size:12pt");
      setAttributeNS(null,"text-anchor","middle");
      setAttributeNS(null,"x","132");
      setAttributeNS(null,"y","20");
      appendChild(document.createTextNode(title));
   }      
   keyGroup.appendChild(titleText);

   var subtitleText=document.createElementNS(svgNS,"text");
   with (subtitleText) {
      setAttributeNS(null,"text-anchor","middle");
      setAttributeNS(null,"x","132");
      setAttributeNS(null,"y","40");
      appendChild(document.createTextNode(subtitle));
   }      
   keyGroup.appendChild(subtitleText);

   var keyText=document.createElementNS(svgNS,"text");
   with (keyText) {
      setAttributeNS(null,"text-anchor","start");
      setAttributeNS(null,"x","10");
      setAttributeNS(null,"y","60");
      appendChild(document.createTextNode("Key:"));
   }      
   keyGroup.appendChild(keyText);

   var keyRoom=document.createElementNS(svgNS,"rect");
   with (keyRoom) {
      setAttributeNS(null,"rx","1");
      setAttributeNS(null,"y","1");
      setAttributeNS(null,"x","10");
      setAttributeNS(null,"y","70");
      setAttributeNS(null,"width","25");
      setAttributeNS(null,"height","13");
      setAttributeNS(null,"stroke","black");
      setAttributeNS(null,"fill","white");
   }      
   keyGroup.appendChild(keyRoom);
   
   var keyRoomText=document.createElementNS(svgNS,"text");
   with (keyRoomText) {
      setAttributeNS(null,"text-anchor","start");
      setAttributeNS(null,"x","55");
      setAttributeNS(null,"y","80");
      appendChild(document.createTextNode("Room"));
   }      
   keyGroup.appendChild(keyRoomText);
   
   var keyJump=document.createElementNS(svgNS,"polygon");
   with (keyJump) {
      setAttributeNS(null,"points","10,103,35,103,22,90");
      setAttributeNS(null,"stroke","black");
      setAttributeNS(null,"fill","white");
   }      
   keyGroup.appendChild(keyJump);
   
   var keyJumpText=document.createElementNS(svgNS,"text");
   with (keyJumpText) {
      setAttributeNS(null,"text-anchor","start");
      setAttributeNS(null,"x","55");
      setAttributeNS(null,"y","100");
      appendChild(document.createTextNode("Go to tab"));
   }      
   keyGroup.appendChild(keyJumpText);
   
   var newLine=document.createElementNS(svgNS,"line");
   with (newLine) {
      setAttributeNS(null,"x1","10");
      setAttributeNS(null,"x2","35");
      setAttributeNS(null,"y1","115");
      setAttributeNS(null,"y2","115");
      setAttributeNS(null,"stroke","black");
      setAttributeNS(null,"stroke-width","2");
   }      
   keyGroup.appendChild(newLine);
   
   var newLineText=document.createElementNS(svgNS,"text");
   with (newLineText) {
      setAttributeNS(null,"text-anchor","start");
      setAttributeNS(null,"x","55");
      setAttributeNS(null,"y","120");
      appendChild(document.createTextNode("Normal Exit"));
   }      
   keyGroup.appendChild(newLineText);

   newLine=document.createElementNS(svgNS,"line");
   with (newLine) {
      setAttributeNS(null,"x1","10");
      setAttributeNS(null,"x2","35");
      setAttributeNS(null,"y1","135");
      setAttributeNS(null,"y2","135");
      setAttributeNS(null,"stroke","black");
      setAttributeNS(null,"stroke-width","2");
      setAttributeNS(null,"stroke-dasharray","5,5");
   }      
   keyGroup.appendChild(newLine);
   
   newLineText=document.createElementNS(svgNS,"text");
   with (newLineText) {
      setAttributeNS(null,"text-anchor","start");
      setAttributeNS(null,"x","55");
      setAttributeNS(null,"y","140");
      appendChild(document.createTextNode("Restricted Exit"));
   }      
   keyGroup.appendChild(newLineText);

   newLine=document.createElementNS(svgNS,"line");
   with (newLine) {
      setAttributeNS(null,"x1","10");
      setAttributeNS(null,"x2","35");
      setAttributeNS(null,"y1","155");
      setAttributeNS(null,"y2","155");
      setAttributeNS(null,"stroke","black");
      setAttributeNS(null,"stroke-width","2");
   }      
   keyGroup.appendChild(newLine);
   
   var newPoly=document.createElementNS(svgNS,"polygon");
   with (newPoly) {
      setAttributeNS(null,"points","31,151,31,159,35,155");
      setAttributeNS(null,"stroke","black");
      setAttributeNS(null,"fill","black");
   }      
   keyGroup.appendChild(newPoly);
   
   newLineText=document.createElementNS(svgNS,"text");
   with (newLineText) {
      setAttributeNS(null,"text-anchor","start");
      setAttributeNS(null,"x","55");
      setAttributeNS(null,"y","160");
      appendChild(document.createTextNode("One way Exit"));
   }      
   keyGroup.appendChild(newLineText);

   newLine=document.createElementNS(svgNS,"line");
   with (newLine) {
      setAttributeNS(null,"x1","10");
      setAttributeNS(null,"x2","35");
      setAttributeNS(null,"y1","175");
      setAttributeNS(null,"y2","175");
      setAttributeNS(null,"stroke","black");
      setAttributeNS(null,"stroke-width","2");
      setAttributeNS(null,"stroke-dasharray","5,5");
   }      
   keyGroup.appendChild(newLine);
   
   newPoly=document.createElementNS(svgNS,"polygon");
   with (newPoly) {
      setAttributeNS(null,"points","31,171,31,179,35,175");
      setAttributeNS(null,"stroke","black");
      setAttributeNS(null,"fill","black");
   }      
   keyGroup.appendChild(newPoly);
   
   newLineText=document.createElementNS(svgNS,"text");
   with (newLineText) {
      setAttributeNS(null,"text-anchor","start");
      setAttributeNS(null,"x","55");
      setAttributeNS(null,"y","180");
      appendChild(document.createTextNode("Restricted One way Exit"));
   }      
   keyGroup.appendChild(newLineText);

   newPoly=document.createElementNS(svgNS,"polygon");
   with (newPoly) {
      setAttributeNS(null,"points","31,171,31,179,35,175");
      setAttributeNS(null,"stroke","black");
      setAttributeNS(null,"fill","black");
   }      
   keyGroup.appendChild(newPoly);
   
   newLineText=document.createElementNS(svgNS,"text");
   with (newLineText) {
      setAttributeNS(null,"text-anchor","start");
      setAttributeNS(null,"x","55");
      setAttributeNS(null,"y","180");
      appendChild(document.createTextNode("Restricted One way Exit"));
   }      
   keyGroup.appendChild(newLineText);

   newPoly=document.createElementNS(svgNS,"polygon");
   with (newPoly) {
      setAttributeNS(null,"points","18,200,26,200,26,192");
      setAttributeNS(null,"stroke","green");
      setAttributeNS(null,"fill","green");
   }      
   keyGroup.appendChild(newPoly);
   
   newLineText=document.createElementNS(svgNS,"text");
   with (newLineText) {
      setAttributeNS(null,"text-anchor","start");
      setAttributeNS(null,"x","55");
      setAttributeNS(null,"y","200");
      appendChild(document.createTextNode("Comments on Location"));
   }      
   keyGroup.appendChild(newLineText);

   newPoly=document.createElementNS(svgNS,"polygon");
   with (newPoly) {
      setAttributeNS(null,"points","18,212,26,212,26,220");
      setAttributeNS(null,"stroke","blue");
      setAttributeNS(null,"fill","blue");
   }      
   keyGroup.appendChild(newPoly);
   
   newLineText=document.createElementNS(svgNS,"text");
   with (newLineText) {
      setAttributeNS(null,"text-anchor","start");
      setAttributeNS(null,"x","55");
      setAttributeNS(null,"y","220");
      appendChild(document.createTextNode("Objects at Location"));
   }      
   keyGroup.appendChild(newLineText);

   newLineText=document.createElementNS(svgNS,"text");
   with (newLineText) {
      setAttributeNS(null,"text-anchor","start");
      setAttributeNS(null,"x","18");
      setAttributeNS(null,"y","240");
      setAttributeNS(null,"style","fill:red");
      appendChild(document.createTextNode("X"));
   }      
   keyGroup.appendChild(newLineText);

   newLineText=document.createElementNS(svgNS,"text");
   with (newLineText) {
      setAttributeNS(null,"text-anchor","start");
      setAttributeNS(null,"x","55");
      setAttributeNS(null,"y","240");
      appendChild(document.createTextNode("Location is fatal"));
   }      
   keyGroup.appendChild(newLineText);
  
   // Now transform the key
   keyGroup.setAttributeNS(null,"transform","translate(" + (absolutewidth + roomXGap) + ",30)");
   document.getElementById("map").appendChild(keyGroup);
}